/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.ide.core.io.preferences.CloakingUtils;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.actions.CopyFilesOperation;
import com.aptana.ide.ui.io.actions.Messages;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Shell;

public class MoveFilesOperation
extends CopyFilesOperation {
    public MoveFilesOperation(Shell shell) {
        super(shell);
    }

    protected boolean copyFile(IFileStore sourceStore, IFileStore destinationStore, IProgressMonitor monitor) {
        if (sourceStore == null || CloakingUtils.isFileCloaked((IFileStore)sourceStore)) {
            return false;
        }
        boolean success = true;
        monitor.subTask(MessageFormat.format(Messages.MoveFilesOperation_Subtask_Moving, sourceStore.getName(), destinationStore.getName()));
        try {
            sourceStore.move(destinationStore, 2, monitor);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)IOUIPlugin.getDefault(), (String)MessageFormat.format(Messages.MoveFilesOperation_ERR_FailedToMove, sourceStore, destinationStore), (Throwable)e);
            success = false;
        }
        return success;
    }
}

